/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#if !defined (_MTCL_H_)
#define _MTCL_H_


#define MTCL_STR_TS      0 
#define MTCL_STR_TS_TVC  1 
#define MTCL_STR_PS      2 
#define MTCL_STR_THROUGH 5 

enum {
	MTCL_CH_REPLAY0, 
	MTCL_CH_REPLAY1, 
	MTCL_CH_REPLAY2, 
	MTCL_CH_REPLAY3, 

	MTCL_CH_RECORD0, 
	MTCL_CH_RECORD1, 
	MTCL_CH_RECORD2, 
	MTCL_CH_RECORD3, 
	MTCL_CH_RECORD4, 

};

#define MTCL_ATS_SYNC          0 
#define MTCL_ATS_ASYNC         1 

#define MTCL_FUNC_SYNC  0 
#define MTCL_FUNC_ASYNC 1 

#define MTCL_INFO_SYNC  0 
#define MTCL_INFO_ASYNC 1 

#define MTCL_BUF_USER 0 
#define MTCL_BUF_LOOP 1 

#define MTCL_PTR_WRITE 0 
#define MTCL_PTR_READ  1 
#define MTCL_PTR_CHECK 2 

#define MTCL_STATE_NOBUF   0  
#define MTCL_STATE_IDLE    1  
#define MTCL_STATE_EXEC    2  
#define MTCL_STATE_CANCEL  3  

#define MTCL_EV_SUCCESS   0x00000001 
#define MTCL_EV_LOOP      0x00000002 
#define MTCL_EV_UNDERFLOW 0x00000004 
#define MTCL_EV_OVERFLOW  0x00000008 
#define MTCL_EV_CHECK     0x00000010 
#define MTCL_EV_ATSLOST   0x00000020 
#define MTCL_EV_CANCELED  0x00000040 

#define MTCL_SIZE_INFINITE  0xFFFFFFFF 


#define MTCL_INVALID_OFFSET 0xFFFFFFFF 

#define MTCL_E_OK          0x00000000 
#define MTCL_E_PARAM       0x82000001 
#define MTCL_E_SEQUENCE    0x82000002 
#define MTCL_E_NOINIT      0x82000003 
#define MTCL_E_NORESOURCE  0x82000004 
#define MTCL_E_SYSTEM      0x82000005 
#define MTCL_E_NOSUPPORT   0x82000006 
#define MTCL_E_BUSY        0x82000007 

typedef struct _MTCL_dmainfo_t {
	UINT8   state;
	UINT32  buf_id;
	UINT32  write_ptr;
	UINT32  read_ptr;
	UINT32  check_ptr;
	UINT32  size;
	UINT32  streamtype;
	UINT32  rate;
	UINT32  info;
} MTCL_dmainfo_t;


typedef void (*MTCL_irq_notify_t)
     ( UINT32 dma_ch, UINT32 result );

INT32 MTCL_init( void );

INT32 MTCL_term( void );

INT32 MTCL_reset_hw( void );

INT32 MTCL_assign_buf_dma( UINT32 dma_ch, UINT32 buf_id, UINT8 loop );

;
INT32 MTCL_release_buf_dma( UINT32 dma_ch );

INT32 MTCL_set_dmaptr( UINT32 dma_ch, UINT8 mode, UINT32 offset );

INT32 MTCL_get_dmainfo( UINT32 dma_ch, MTCL_dmainfo_t *dma_info );

INT32 MTCL_set_streamtype( UINT32 dma_ch, UINT8 stream );

INT32 MTCL_set_dmarate( UINT32 dma_ch, UINT32 rate, UINT8 mode );


INT32 MTCL_start_dma( UINT32 dma_ch, UINT32 size, UINT32 offset, UINT8 mode,
                      UINT8 sync_ptr );

INT32 MTCL_stop_dma( UINT32 dma_ch );

INT32 MTCL_reset_dma( UINT32 dma_ch );

INT32 MTCL_register_dmanotify( UINT32 dma_ch, MTCL_irq_notify_t notify );

INT32 MTCL_unregister_dmanotify( UINT32 dma_ch );

INT32 MTCL_set_eventmask( UINT32 dma_ch, UINT32 mask );


INT32 MTCL_get_atslost_ptr( UINT32 dma_ch, UINT32 *ats_lost );

INT32 MTCL_get_dmatime( UINT32 dma_ch, UINT32 *start_time, UINT32 *end_time );

INT32 MTCL_get_hw_dmainfo( UINT32 dma_ch, UINT32 *hw_info );

#endif 

